/*
 * Decompiled with CFR 0.152.
 */
package favorites;

import favorites.FavoritesList;
import favorites.FileTreeNode;
import favorites.FileTreeNodeForHistory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.gjt.sp.jedit.BufferHistory;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EBPlugin;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.util.Log;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class FavoritesPlugin
extends EBPlugin {
    private FavoritesList lastList = null;

    public void handleMessage(EBMessage msg) {
        ViewUpdate vumsg;
        BufferUpdate bmsg;
        if (msg instanceof BufferUpdate && (bmsg = (BufferUpdate)msg).getWhat().equals(BufferUpdate.CLOSED)) {
            if (bmsg.getView() == null) {
                return;
            }
            FavoritesPlugin.reloadHistory(bmsg.getView());
        }
        if (msg instanceof ViewUpdate && (vumsg = (ViewUpdate)msg).getWhat().equals(ViewUpdate.CLOSED)) {
            this.lastList = FavoritesList.removeFavoritesList((View)msg.getSource());
        }
    }

    public static String getHistoryKey() {
        return "# Recent Files";
    }

    public static void reloadHistory(View view) {
        final FavoritesList cur = FavoritesList.getFavoritesList(view);
        if (cur == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileTreeNode root = cur.getRoot();
                FileTreeNode history = cur.getHistory();
                boolean reloadAll = history == null;
                root.deleteNode(history);
                history = FavoritesPlugin.loadHistory();
                root.addNode(history);
                if (reloadAll) {
                    FavoritesList.reloadAll();
                } else {
                    FavoritesList.reloadAll(history);
                }
            }
        });
    }

    public void stop() {
        FavoritesPlugin.saveXML(this.lastList);
    }

    public static void add() {
        View view = jEdit.getActiveView();
        FavoritesList cur = FavoritesList.getFavoritesList(view);
        if (cur != null) {
            cur.add();
            FavoritesPlugin.saveXML();
        }
    }

    public static void addPath() {
        View view = jEdit.getActiveView();
        FavoritesList cur = FavoritesList.getFavoritesList(view);
        if (cur != null) {
            cur.addPath();
            FavoritesPlugin.saveXML();
        }
    }

    public static void addParentPath() {
        View view = jEdit.getActiveView();
        FavoritesList cur = FavoritesList.getFavoritesList(view);
        if (cur != null) {
            cur.addParentPath();
            FavoritesPlugin.saveXML();
        }
    }

    public static void delete() {
        View view = jEdit.getActiveView();
        FavoritesList cur = FavoritesList.getFavoritesList(view);
        if (cur != null) {
            cur.delete();
            FavoritesPlugin.saveXML();
        }
    }

    public static void addGroup() {
        View view = jEdit.getActiveView();
        FavoritesList cur = FavoritesList.getFavoritesList(view);
        if (cur != null) {
            cur.addGroup();
            FavoritesPlugin.saveXML();
        }
    }

    public static void addBuffers() {
        View view = jEdit.getActiveView();
        FavoritesList cur = FavoritesList.getFavoritesList(view);
        if (cur != null) {
            cur.addBuffers();
            FavoritesPlugin.saveXML();
        }
    }

    private static FileTreeNode loadHistory() {
        FileTreeNode root = null;
        List entrys = BufferHistory.getHistory();
        BufferHistory.Entry entry = null;
        root = new FileTreeNode(FavoritesPlugin.getHistoryKey());
        Iterator it = entrys.iterator();
        int historyOrder = 0;
        while (it.hasNext()) {
            entry = (BufferHistory.Entry)it.next();
            root.addNode(new FileTreeNodeForHistory(MiscUtilities.getFileName((String)entry.path), entry.path, historyOrder++));
        }
        return root;
    }

    public static FileTreeNode createRoot() {
        FileTreeNode root = FavoritesPlugin.loadXML();
        if (root == null) {
            root = new FileTreeNode("root");
        }
        root.addNode(FavoritesPlugin.loadHistory());
        return root;
    }

    private static FileTreeNode loadXML() {
        String settingPath = MiscUtilities.constructPath((String)jEdit.getSettingsDirectory(), (String)"favorites");
        FileTreeNode root = null;
        File file = null;
        try {
            file = new File(settingPath, "favorites.xml");
            if (!file.exists()) {
                return root;
            }
        }
        catch (Exception e) {
            Log.log((int)9, FavoritesPlugin.class, (Object)e);
            return root;
        }
        try {
            SAXParserFactory spfactory = SAXParserFactory.newInstance();
            SAXParser parser = spfactory.newSAXParser();
            FavoritesXmlHandler handler = new FavoritesXmlHandler();
            parser.parse(file, (DefaultHandler)handler);
            root = handler.getRoot();
        }
        catch (Exception e) {
            Log.log((int)9, FavoritesPlugin.class, (Object)e);
        }
        return root;
    }

    private static void saveXML() {
        View view = jEdit.getActiveView();
        FavoritesList cur = FavoritesList.getFavoritesList(view);
        if (cur == null) {
            return;
        }
        FavoritesPlugin.saveXML(cur);
    }

    private static void saveXML(FavoritesList cur) {
        if (cur == null) {
            return;
        }
        FileTreeNode root = (FileTreeNode)cur.getRoot().clone();
        root.deleteNode(cur.getHistory());
        String settingPath = MiscUtilities.constructPath((String)jEdit.getSettingsDirectory(), (String)"favorites");
        BufferedWriter bw = null;
        try {
            File file = new File(settingPath);
            if (!file.exists()) {
                file.mkdirs();
            }
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(settingPath, "favorites.xml")), "UTF-8"));
        }
        catch (Exception e) {
            Log.log((int)9, FavoritesPlugin.class, (Object)e);
            return;
        }
        FavoritesPlugin.saveFavorites(bw, root, true);
        try {
            if (bw != null) {
                bw.close();
            }
        }
        catch (Exception e) {
            Log.log((int)9, FavoritesPlugin.class, (Object)e);
        }
    }

    private static boolean saveFavorites(BufferedWriter bw, FileTreeNode node, boolean rootnode) {
        boolean result = false;
        try {
            if (rootnode) {
                bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                bw.newLine();
            }
            bw.write("<GROUP name=\"");
            bw.write(node.getName());
            bw.write("\">");
            bw.newLine();
            Enumeration en = node.children();
            while (en.hasMoreElements()) {
                FileTreeNode el = (FileTreeNode)en.nextElement();
                if (el.isLeaf()) {
                    bw.write("  <FILE path=\"");
                    String path = el.getPath();
                    path = path.replace('\\', '/');
                    bw.write(path);
                    bw.write("\"  name=\"");
                    bw.write(el.getName());
                    bw.write("\"  type=\"");
                    bw.write(el.getType());
                    bw.write("\"/>");
                    bw.newLine();
                    continue;
                }
                FavoritesPlugin.saveFavorites(bw, el, false);
            }
            bw.write("</GROUP>");
            bw.newLine();
            result = true;
        }
        catch (Exception e) {
            Log.log((int)9, FavoritesPlugin.class, (Object)e);
        }
        return result;
    }

    private static class FavoritesXmlHandler
    extends DefaultHandler {
        FileTreeNode node = null;

        private FavoritesXmlHandler() {
        }

        public FileTreeNode getRoot() {
            return this.node;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if ("GROUP".equals(qName)) {
                String name = attributes.getValue("name");
                if (name == null) {
                    return;
                }
                FileTreeNode newNode = new FileTreeNode(name);
                if (this.node != null) {
                    this.node.addNode(newNode);
                }
                this.node = newNode;
            } else if ("FILE".equals(qName)) {
                String name = attributes.getValue("name");
                if (name == null) {
                    return;
                }
                String path = attributes.getValue("path");
                if (path == null) {
                    return;
                }
                String type = attributes.getValue("type");
                if (type == null) {
                    type = FileTreeNode.TYPE_FILE;
                }
                FileTreeNode newNode = new FileTreeNode(name, path, type);
                if (this.node != null) {
                    this.node.addNode(newNode);
                }
            }
        }

        @Override
        public void characters(char[] ch, int offset, int length) {
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if ("GROUP".equals(qName) && this.node != null && this.node.getParent() != null) {
                this.node = (FileTreeNode)this.node.getParent();
            }
        }
    }
}

