/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRStringUtil;

public class RunHelper
extends BaseHelper {
    private Map fontMap = null;

    public RunHelper(Writer writer, Map fontMap) {
        super(writer);
        this.fontMap = fontMap;
    }

    public void export(JRStyle style, Map attributes, String text) throws IOException {
        if (text != null) {
            this.writer.write("      <w:r>\n");
            this.exportProps(this.getAttributes(style), attributes);
            StringTokenizer tkzer = new StringTokenizer(text, "\n", true);
            while (tkzer.hasMoreTokens()) {
                String token = tkzer.nextToken();
                if ("\n".equals(token)) {
                    this.writer.write("<w:br/>");
                    continue;
                }
                this.writer.write("<w:t xml:space=\"preserve\">");
                this.writer.write(JRStringUtil.xmlEncode(token));
                this.writer.write("</w:t>\n");
            }
            this.writer.write("      </w:r>\n");
        }
    }

    public void exportProps(JRStyle style) throws IOException {
        JRBasePrintText text = new JRBasePrintText(null);
        text.setStyle(style);
        HashMap<TextAttribute, Color> styledTextAttributes = new HashMap<TextAttribute, Color>();
        JRFontUtil.getAttributes(styledTextAttributes, text, null);
        styledTextAttributes.put(TextAttribute.FOREGROUND, text.getForecolor());
        if (style.getMode() == null || style.getMode() == 1) {
            styledTextAttributes.put(TextAttribute.BACKGROUND, style.getBackcolor());
        }
        this.exportProps(this.getAttributes(style.getStyle()), this.getAttributes(style));
    }

    public void exportProps(Map parentAttrs, Map attrs) throws IOException {
        this.writer.write("       <w:rPr>\n");
        Object value = attrs.get(TextAttribute.FAMILY);
        Object oldValue = parentAttrs.get(TextAttribute.FAMILY);
        if (value != null && !value.equals(oldValue)) {
            String fontFamilyAttr = (String)value;
            String fontFamily = this.fontMap != null && this.fontMap.containsKey(fontFamilyAttr) ? (String)this.fontMap.get(fontFamilyAttr) : fontFamilyAttr;
            this.writer.write("        <w:rFonts w:ascii=\"" + fontFamily + "\" w:hAnsi=\"" + fontFamily + "\" w:eastAsia=\"" + fontFamily + "\" w:cs=\"" + fontFamily + "\" />\n");
        }
        value = attrs.get(TextAttribute.FOREGROUND);
        oldValue = parentAttrs.get(TextAttribute.FOREGROUND);
        if (value != null && !value.equals(oldValue)) {
            this.writer.write("        <w:color w:val=\"" + JRColorUtil.getColorHexa((Color)value) + "\" />\n");
        }
        value = attrs.get(TextAttribute.BACKGROUND);
        oldValue = parentAttrs.get(TextAttribute.BACKGROUND);
        if (value == null || !value.equals(oldValue)) {
            // empty if block
        }
        value = attrs.get(TextAttribute.SIZE);
        oldValue = parentAttrs.get(TextAttribute.SIZE);
        if (value != null && !value.equals(oldValue)) {
            this.writer.write("        <w:sz w:val=\"" + 2.0f * ((Float)value).floatValue() + "\" />\n");
        }
        value = attrs.get(TextAttribute.WEIGHT);
        oldValue = parentAttrs.get(TextAttribute.WEIGHT);
        if (value != null && !value.equals(oldValue)) {
            this.writer.write("        <w:b w:val=\"" + value.equals(TextAttribute.WEIGHT_BOLD) + "\"/>\n");
        }
        value = attrs.get(TextAttribute.POSTURE);
        oldValue = parentAttrs.get(TextAttribute.POSTURE);
        if (value != null && !value.equals(oldValue)) {
            this.writer.write("        <w:i w:val=\"" + value.equals(TextAttribute.POSTURE_OBLIQUE) + "\"/>\n");
        }
        value = attrs.get(TextAttribute.UNDERLINE);
        oldValue = parentAttrs.get(TextAttribute.UNDERLINE);
        if (value == null && oldValue != null || value != null && !value.equals(oldValue)) {
            this.writer.write("        <w:u w:val=\"" + (value == null ? "none" : "single") + "\"/>\n");
        }
        value = attrs.get(TextAttribute.STRIKETHROUGH);
        oldValue = parentAttrs.get(TextAttribute.STRIKETHROUGH);
        if (value == null && oldValue != null || value != null && !value.equals(oldValue)) {
            this.writer.write("        <w:strike w:val=\"" + (value != null) + "\"/>\n");
        }
        if (TextAttribute.SUPERSCRIPT_SUPER.equals(value = attrs.get(TextAttribute.SUPERSCRIPT))) {
            this.writer.write("        <w:vertAlign w:val=\"superscript\" />\n");
        } else if (TextAttribute.SUPERSCRIPT_SUB.equals(value)) {
            this.writer.write("        <w:vertAlign w:val=\"subscript\" />\n");
        }
        this.writer.write("       </w:rPr>\n");
    }

    private Map getAttributes(JRStyle style) throws IOException {
        JRBasePrintText text = new JRBasePrintText(null);
        text.setStyle(style);
        HashMap<TextAttribute, Color> styledTextAttributes = new HashMap<TextAttribute, Color>();
        JRFontUtil.getAttributes(styledTextAttributes, text, null);
        styledTextAttributes.put(TextAttribute.FOREGROUND, text.getForecolor());
        if (text.getMode() == 1) {
            styledTextAttributes.put(TextAttribute.BACKGROUND, text.getBackcolor());
        }
        return styledTextAttributes;
    }
}

