"use strict";exports.__esModule=true;exports.collectPages=collectPages;exports.printTreeView=printTreeView;exports.printCustomRoutes=printCustomRoutes;exports.getSharedSizes=getSharedSizes;exports.getPageSizeInKb=getPageSizeInKb;exports.isPageStatic=isPageStatic;exports.hasCustomAppGetInitialProps=hasCustomAppGetInitialProps;var _chalk=_interopRequireDefault(require("chalk"));var _gzipSize=_interopRequireDefault(require("gzip-size"));var _textTable=_interopRequireDefault(require("next/dist/compiled/text-table"));var _path=_interopRequireDefault(require("path"));var _reactIs=require("react-is");var _stripAnsi=_interopRequireDefault(require("strip-ansi"));var _checkCustomRoutes=require("../lib/check-custom-routes");var _constants=require("../lib/constants");var _prettyBytes=_interopRequireDefault(require("../lib/pretty-bytes"));var _recursiveReaddir=require("../lib/recursive-readdir");var _utils=require("../next-server/lib/router/utils");var _isDynamic=require("../next-server/lib/router/utils/is-dynamic");var _findPageFile=require("../server/lib/find-page-file");function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}const fileGzipStats={};const fsStatGzip=file=>{if(fileGzipStats[file])return fileGzipStats[file];fileGzipStats[file]=_gzipSize.default.file(file);return fileGzipStats[file];};function collectPages(directory,pageExtensions){return(0,_recursiveReaddir.recursiveReadDir)(directory,new RegExp(`\\.(?:${pageExtensions.join('|')})$`));}async function printTreeView(list,pageInfos,serverless,{distPath,buildId,pagesDir,pageExtensions,buildManifest,isModern}){const getPrettySize=_size=>{const size=(0,_prettyBytes.default)(_size);// green for 0-130kb
if(_size<130*1000)return _chalk.default.green(size);// yellow for 130-170kb
if(_size<170*1000)return _chalk.default.yellow(size);// red for >= 170kb
return _chalk.default.red.bold(size);};const messages=[['Page','Size','First Load'].map(entry=>_chalk.default.underline(entry))];const hasCustomApp=await(0,_findPageFile.findPageFile)(pagesDir,'/_app',pageExtensions);const hasCustomError=await(0,_findPageFile.findPageFile)(pagesDir,'/_error',pageExtensions);const pageList=list.slice().filter(e=>!(e==='/_document'||!hasCustomApp&&e==='/_app'||!hasCustomError&&e==='/_error')).sort((a,b)=>a.localeCompare(b));pageList.forEach((item,i,arr)=>{var _pageInfo$ssgPageRout;const symbol=i===0?arr.length===1?'─':'┌':i===arr.length-1?'└':'├';const pageInfo=pageInfos.get(item);messages.push([`${symbol} ${item==='/_app'?' ':(pageInfo===null||pageInfo===void 0?void 0:pageInfo.static)?'○':(pageInfo===null||pageInfo===void 0?void 0:pageInfo.isSsg)?'●':'λ'} ${item}`,pageInfo?pageInfo.isAmp?_chalk.default.cyan('AMP'):pageInfo.size>=0?(0,_prettyBytes.default)(pageInfo.size):'':'',pageInfo?pageInfo.isAmp?_chalk.default.cyan('AMP'):pageInfo.size>=0?getPrettySize(pageInfo.totalSize):'':'']);if(pageInfo===null||pageInfo===void 0?void 0:(_pageInfo$ssgPageRout=pageInfo.ssgPageRoutes)===null||_pageInfo$ssgPageRout===void 0?void 0:_pageInfo$ssgPageRout.length){const totalRoutes=pageInfo.ssgPageRoutes.length;const previewPages=totalRoutes===4?4:3;const contSymbol=i===arr.length-1?' ':'├';const routes=pageInfo.ssgPageRoutes.slice(0,previewPages);if(totalRoutes>previewPages){const remaining=totalRoutes-previewPages;routes.push(`[+${remaining} more paths]`);}routes.forEach((slug,index,{length})=>{const innerSymbol=index===length-1?'└':'├';messages.push([`${contSymbol}   ${innerSymbol} ${slug}`,'','']);});}});const sharedData=await getSharedSizes(distPath,buildManifest,buildId,isModern,pageInfos);messages.push(['+ shared by all',getPrettySize(sharedData.total),'']);Object.keys(sharedData.files).map(e=>e.replace(buildId,'<buildId>')).sort().forEach((fileName,index,{length})=>{const innerSymbol=index===length-1?'└':'├';const originalName=fileName.replace('<buildId>',buildId);const cleanName=fileName// Trim off `static/`
.replace(/^static\//,'')// Re-add `static/` for root files
.replace(/^<buildId>/,'static')// Remove file hash
.replace(/[.-]([0-9a-z]{6})[0-9a-z]{14}(?=\.)/,'.$1');messages.push([`  ${innerSymbol} ${cleanName}`,(0,_prettyBytes.default)(sharedData.files[originalName]),'']);});console.log((0,_textTable.default)(messages,{align:['l','l','r'],stringLength:str=>(0,_stripAnsi.default)(str).length}));console.log();console.log((0,_textTable.default)([['λ',serverless?'(Lambda)':'(Server)',`server-side renders at runtime (uses ${_chalk.default.cyan('getInitialProps')} or ${_chalk.default.cyan('getServerProps')})`],['○','(Static)','automatically rendered as static HTML (uses no initial props)'],['●','(SSG)',`automatically generated as static HTML + JSON (uses ${_chalk.default.cyan('getStaticProps')})`]],{align:['l','l','l'],stringLength:str=>(0,_stripAnsi.default)(str).length}));console.log();}function printCustomRoutes({redirects,rewrites}){const printRoutes=(routes,type)=>{const isRedirects=type==='Redirects';console.log(_chalk.default.underline(type));console.log();console.log((0,_textTable.default)([['Source','Destination',...(isRedirects?['statusCode']:[])].map(str=>_chalk.default.bold(str)),...Object.entries(routes).map(([key,route])=>{return[route.source,route.destination,...(isRedirects?[(0,_checkCustomRoutes.getRedirectStatus)(route)+'']:[])];})],{align:['l','l','l'],stringLength:str=>(0,_stripAnsi.default)(str).length}));console.log();};if(redirects.length){printRoutes(redirects,'Redirects');}if(rewrites.length){printRoutes(rewrites,'Rewrites');}}let cachedBuildManifest;let lastCompute;let lastComputeModern;let lastComputePageInfo;async function computeFromManifest(manifest,distPath,buildId,isModern,pageInfos){if(Object.is(cachedBuildManifest,manifest)&&lastComputeModern===isModern&&lastComputePageInfo===!!pageInfos){return lastCompute;}let expected=0;const files=new Map();Object.keys(manifest.pages).forEach(key=>{if(key==='/_polyfills'){return;}if(pageInfos){const cleanKey=key.replace(/\/index$/,'')||'/';const pageInfo=pageInfos.get(cleanKey);// don't include AMP pages since they don't rely on shared bundles
if((pageInfo===null||pageInfo===void 0?void 0:pageInfo.isHybridAmp)||(pageInfo===null||pageInfo===void 0?void 0:pageInfo.isAmp)){return;}}++expected;manifest.pages[key].forEach(file=>{if(// Filter out CSS
!file.endsWith('.js')||// Select Modern or Legacy scripts
file.endsWith('.module.js')!==isModern){return;}if(key==='/_app'){files.set(file,Infinity);}else if(files.has(file)){files.set(file,files.get(file)+1);}else{files.set(file,1);}});});// Add well-known shared file
files.set(_path.default.posix.join(`static/${buildId}/pages/`,`/_app${isModern?'.module':''}.js`),Infinity);const commonFiles=[...files.entries()].filter(([,len])=>len===expected||len===Infinity).map(([f])=>f);const uniqueFiles=[...files.entries()].filter(([,len])=>len===1).map(([f])=>f);let stats;try{stats=await Promise.all(commonFiles.map(async f=>[f,await fsStatGzip(_path.default.join(distPath,f))]));}catch(_){stats=[];}lastCompute={commonFiles,uniqueFiles,sizeCommonFile:stats.reduce((obj,n)=>Object.assign(obj,{[n[0]]:n[1]}),{}),sizeCommonFiles:stats.reduce((size,[,stat])=>size+stat,0)};cachedBuildManifest=manifest;lastComputeModern=isModern;lastComputePageInfo=!!pageInfos;return lastCompute;}function difference(main,sub){const a=new Set(main);const b=new Set(sub);return[...a].filter(x=>!b.has(x));}function intersect(main,sub){const a=new Set(main);const b=new Set(sub);return[...new Set([...a].filter(x=>b.has(x)))];}function sum(a){return a.reduce((size,stat)=>size+stat,0);}async function getSharedSizes(distPath,buildManifest,buildId,isModern,pageInfos){const data=await computeFromManifest(buildManifest,distPath,buildId,isModern,pageInfos);return{total:data.sizeCommonFiles,files:data.sizeCommonFile};}async function getPageSizeInKb(page,distPath,buildId,buildManifest,isModern){const data=await computeFromManifest(buildManifest,distPath,buildId,isModern);const fnFilterModern=entry=>entry.endsWith('.js')&&entry.endsWith('.module.js')===isModern;const pageFiles=(buildManifest.pages[page]||[]).filter(fnFilterModern);const appFiles=(buildManifest.pages['/_app']||[]).filter(fnFilterModern);const fnMapRealPath=dep=>`${distPath}/${dep}`;const allFilesReal=[...new Set([...pageFiles,...appFiles])].map(fnMapRealPath);const selfFilesReal=difference(intersect(pageFiles,data.uniqueFiles),data.commonFiles).map(fnMapRealPath);const clientBundle=_path.default.join(distPath,`static/${buildId}/pages/`,`${page}${isModern?'.module':''}.js`);const appBundle=_path.default.join(distPath,`static/${buildId}/pages/`,`/_app${isModern?'.module':''}.js`);selfFilesReal.push(clientBundle);allFilesReal.push(clientBundle);if(clientBundle!==appBundle){allFilesReal.push(appBundle);}try{// Doesn't use `Promise.all`, as we'd double compute duplicate files. This
// function is memoized, so the second one will instantly resolve.
const allFilesSize=sum((await Promise.all(allFilesReal.map(fsStatGzip))));const selfFilesSize=sum((await Promise.all(selfFilesReal.map(fsStatGzip))));return[selfFilesSize,allFilesSize];}catch(_){}return[-1,-1];}async function isPageStatic(page,serverBundle,runtimeEnvConfig){try{require('../next-server/lib/runtime-config').setConfig(runtimeEnvConfig);const mod=require(serverBundle);const Comp=mod.default||mod;if(!Comp||!(0,_reactIs.isValidElementType)(Comp)||typeof Comp==='string'){throw new Error('INVALID_DEFAULT_EXPORT');}const hasGetInitialProps=!!Comp.getInitialProps;const hasStaticProps=!!mod.unstable_getStaticProps;const hasStaticPaths=!!mod.unstable_getStaticPaths;const hasLegacyStaticParams=!!mod.unstable_getStaticParams;if(hasLegacyStaticParams){throw new Error(`unstable_getStaticParams was replaced with unstable_getStaticPaths. Please update your code.`);}// A page cannot be prerendered _and_ define a data requirement. That's
// contradictory!
if(hasGetInitialProps&&hasStaticProps){throw new Error(_constants.SSG_GET_INITIAL_PROPS_CONFLICT);}// A page cannot have static parameters if it is not a dynamic page.
if(hasStaticProps&&hasStaticPaths&&!(0,_isDynamic.isDynamicRoute)(page)){throw new Error(`unstable_getStaticPaths can only be used with dynamic pages. https://nextjs.org/docs#dynamic-routing`);}let prerenderPaths;if(hasStaticProps&&hasStaticPaths){prerenderPaths=[];const _routeRegex=(0,_utils.getRouteRegex)(page);const _routeMatcher=(0,_utils.getRouteMatcher)(_routeRegex);// Get the default list of allowed params.
const _validParamKeys=Object.keys(_routeMatcher(page));const toPrerender=await mod.unstable_getStaticPaths();toPrerender.forEach(entry=>{// For a string-provided path, we must make sure it matches the dynamic
// route.
if(typeof entry==='string'){const result=_routeMatcher(entry);if(!result){throw new Error(`The provided path \`${entry}\` does not match the page: \`${page}\`.`);}prerenderPaths.push(entry);}// For the object-provided path, we must make sure it specifies all
// required keys.
else{const invalidKeys=Object.keys(entry).filter(key=>key!=='params');if(invalidKeys.length){throw new Error(`Additional keys were returned from \`unstable_getStaticPaths\` in page "${page}". `+`URL Parameters intended for this dynamic route must be nested under the \`params\` key, i.e.:`+`\n\n\treturn { params: { ${_validParamKeys.map(k=>`${k}: ...`).join(', ')} } }`+`\n\nKeys that need to be moved: ${invalidKeys.join(', ')}.\n`);}const{params={}}=entry;let builtPage=page;_validParamKeys.forEach(validParamKey=>{const{repeat}=_routeRegex.groups[validParamKey];const paramValue=params[validParamKey];if(repeat&&!Array.isArray(paramValue)||!repeat&&typeof paramValue!=='string'){throw new Error(`A required parameter (${validParamKey}) was not provided as ${repeat?'an array':'a string'}.`);}builtPage=builtPage.replace(`[${repeat?'...':''}${validParamKey}]`,encodeURIComponent(repeat?paramValue.join('/'):paramValue));});prerenderPaths.push(builtPage);}});}const config=mod.config||{};return{static:!hasStaticProps&&!hasGetInitialProps,isHybridAmp:config.amp==='hybrid',prerenderRoutes:prerenderPaths,prerender:hasStaticProps};}catch(err){if(err.code==='MODULE_NOT_FOUND')return{};throw err;}}function hasCustomAppGetInitialProps(_appBundle,runtimeEnvConfig){require('../next-server/lib/runtime-config').setConfig(runtimeEnvConfig);let mod=require(_appBundle);if(_appBundle.endsWith('_app.js')){mod=mod.default||mod;}else{// since we don't output _app in serverless mode get it from a page
mod=mod._app;}return mod.getInitialProps!==mod.origGetInitialProps;}