/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.ejb;

import java.util.concurrent.ConcurrentMap;
import org.seasar.framework.ejb.EJB3Desc;
import org.seasar.framework.ejb.impl.EJB3DescImpl;
import org.seasar.framework.util.Disposable;
import org.seasar.framework.util.DisposableUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJB3DescFactory {
    private static boolean initialized;
    protected static final ConcurrentMap<Class<?>, EJB3DescImpl> ejb3Descs;

    public static void initialize() {
        if (initialized) {
            return;
        }
        DisposableUtil.add((Disposable)new Disposable(){

            public void dispose() {
                EJB3DescFactory.dispose();
            }
        });
        initialized = true;
    }

    public static void dispose() {
        ejb3Descs.clear();
        initialized = false;
    }

    public static EJB3Desc getEJB3Desc(Class<?> beanClass) {
        EJB3DescFactory.initialize();
        EJB3DescImpl ejb3Desc = (EJB3DescImpl)ejb3Descs.get(beanClass);
        if (ejb3Desc == null) {
            ejb3Desc = CollectionsUtil.putIfAbsent(ejb3Descs, beanClass, new EJB3DescImpl(beanClass));
        }
        return ejb3Desc.isEJB3() ? ejb3Desc : null;
    }

    static {
        ejb3Descs = CollectionsUtil.newConcurrentHashMap();
        EJB3DescFactory.initialize();
    }
}

