/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc;

import java.util.Map;
import org.seasar.framework.util.tiger.CollectionsUtil;

public class SelectClause {
    protected StringBuilder sql;
    protected int aliasIndex;
    protected Map<String, String> columnAliases = CollectionsUtil.newHashMap(64);

    public SelectClause() {
        this(300);
    }

    public SelectClause(int capacity) {
        this.sql = new StringBuilder(capacity);
    }

    public int getLength() {
        return this.sql.length();
    }

    public String toSql() {
        return this.sql.toString();
    }

    public void addSql(String tableAlias, String columnName) {
        if (this.sql.length() > 0) {
            this.sql.append(", ");
        }
        String qname = tableAlias + '.' + columnName;
        String columnAlias = "C" + ++this.aliasIndex + "_";
        this.columnAliases.put(qname, columnAlias);
        this.sql.append(qname).append(" as ").append(columnAlias);
    }

    public void addSql(String selectItem) {
        if (this.sql.length() > 0) {
            this.sql.append(", ");
        }
        this.sql.append(selectItem);
    }

    public String getColumnAlias(String tableAlias, String columnName) {
        return this.getColumnAlias(tableAlias + '.' + columnName);
    }

    public String getColumnAlias(String qname) {
        return this.columnAliases.get(qname);
    }
}

