/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model.textproperties;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import org.apache.poi.hslf.model.textproperties.TextProp;
import org.apache.poi.hslf.record.StyleTextPropAtom;
import org.apache.poi.util.LittleEndian;

public class TextPropCollection {
    private int charactersCovered;
    private short reservedField;
    private LinkedList textPropList;

    public int getCharactersCovered() {
        return this.charactersCovered;
    }

    public LinkedList getTextPropList() {
        return this.textPropList;
    }

    public TextProp findByName(String textPropName) {
        for (int i = 0; i < this.textPropList.size(); ++i) {
            TextProp prop = (TextProp)this.textPropList.get(i);
            if (!prop.getName().equals(textPropName)) continue;
            return prop;
        }
        return null;
    }

    public TextProp addWithName(String name) {
        int i;
        TextProp base = null;
        for (i = 0; i < StyleTextPropAtom.characterTextPropTypes.length; ++i) {
            if (!StyleTextPropAtom.characterTextPropTypes[i].getName().equals(name)) continue;
            base = StyleTextPropAtom.characterTextPropTypes[i];
        }
        for (i = 0; i < StyleTextPropAtom.paragraphTextPropTypes.length; ++i) {
            if (!StyleTextPropAtom.paragraphTextPropTypes[i].getName().equals(name)) continue;
            base = StyleTextPropAtom.paragraphTextPropTypes[i];
        }
        if (base == null) {
            throw new IllegalArgumentException("No TextProp with name " + name + " is defined to add from");
        }
        TextProp textProp = (TextProp)base.clone();
        int pos = 0;
        for (int i2 = 0; i2 < this.textPropList.size(); ++i2) {
            TextProp curProp = (TextProp)this.textPropList.get(i2);
            if (textProp.getMask() <= curProp.getMask()) continue;
            ++pos;
        }
        this.textPropList.add(pos, textProp);
        return textProp;
    }

    public int buildTextPropList(int containsField, TextProp[] potentialProperties, byte[] data, int dataOffset) {
        int bytesPassed = 0;
        for (int i = 0; i < potentialProperties.length; ++i) {
            if (dataOffset + bytesPassed >= data.length) {
                return bytesPassed;
            }
            if ((containsField & potentialProperties[i].getMask()) == 0) continue;
            TextProp prop = (TextProp)potentialProperties[i].clone();
            int val = 0;
            val = prop.getSize() == 2 ? LittleEndian.getShort(data, dataOffset + bytesPassed) : LittleEndian.getInt(data, dataOffset + bytesPassed);
            prop.setValue(val);
            bytesPassed += prop.getSize();
            this.textPropList.add(prop);
        }
        return bytesPassed;
    }

    public TextPropCollection(int charactersCovered, short reservedField) {
        this.charactersCovered = charactersCovered;
        this.reservedField = reservedField;
        this.textPropList = new LinkedList();
    }

    public TextPropCollection(int textSize) {
        this.charactersCovered = textSize;
        this.reservedField = (short)-1;
        this.textPropList = new LinkedList();
    }

    public void updateTextSize(int textSize) {
        this.charactersCovered = textSize;
    }

    public void writeOut(OutputStream o) throws IOException {
        TextProp textProp;
        int i;
        StyleTextPropAtom.writeLittleEndian(this.charactersCovered, o);
        if (this.reservedField > -1) {
            StyleTextPropAtom.writeLittleEndian(this.reservedField, o);
        }
        int mask = 0;
        for (i = 0; i < this.textPropList.size(); ++i) {
            textProp = (TextProp)this.textPropList.get(i);
            mask += textProp.getWriteMask();
        }
        StyleTextPropAtom.writeLittleEndian(mask, o);
        for (i = 0; i < this.textPropList.size(); ++i) {
            textProp = (TextProp)this.textPropList.get(i);
            int val = textProp.getValue();
            if (textProp.getSize() == 2) {
                StyleTextPropAtom.writeLittleEndian((short)val, o);
                continue;
            }
            StyleTextPropAtom.writeLittleEndian(val, o);
        }
    }

    public short getReservedField() {
        return this.reservedField;
    }

    public void setReservedField(short val) {
        this.reservedField = val;
    }
}

