/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.LittleEndian;

public class InteractiveInfoAtom
extends RecordAtom {
    private byte[] _header = new byte[8];
    private byte[] _data;

    protected InteractiveInfoAtom() {
        this._data = new byte[16];
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        LittleEndian.putInt(this._header, 4, this._data.length);
    }

    protected InteractiveInfoAtom(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._data = new byte[len - 8];
        System.arraycopy(source, start + 8, this._data, 0, len - 8);
        if (this._data.length < 16) {
            throw new IllegalArgumentException("The length of the data for a InteractiveInfoAtom must be at least 16 bytes, but was only " + this._data.length);
        }
    }

    public int getNumber() {
        return LittleEndian.getInt(this._data, 4);
    }

    public void setNumber(int number) {
        LittleEndian.putInt(this._data, 4, number);
    }

    public int _getNumber1() {
        return LittleEndian.getInt(this._data, 0);
    }

    protected void _setNumber1(int val) {
        LittleEndian.putInt(this._data, 0, val);
    }

    public int _getNumber3() {
        return LittleEndian.getInt(this._data, 8);
    }

    protected void _setNumber3(int val) {
        LittleEndian.putInt(this._data, 8, val);
    }

    public int _getNumber4() {
        return LittleEndian.getInt(this._data, 12);
    }

    protected void _setNumber4(int val) {
        LittleEndian.putInt(this._data, 12, val);
    }

    public long getRecordType() {
        return RecordTypes.InteractiveInfoAtom.typeID;
    }

    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._data);
    }
}

