/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.poifs.storage.ListManagedBlock;
import org.apache.poi.util.IOUtils;

public class RawDataBlock
implements ListManagedBlock {
    private byte[] _data = new byte[512];
    private boolean _eof;

    public RawDataBlock(InputStream stream) throws IOException {
        int count = IOUtils.readFully(stream, this._data);
        if (count == -1) {
            this._eof = true;
        } else {
            if (count != 512) {
                if (count == -1) {
                    count = 0;
                }
                String type = " byte" + (count == 1 ? "" : "s");
                throw new IOException("Unable to read entire block; " + count + type + " read; expected " + 512 + " bytes");
            }
            this._eof = false;
        }
    }

    public boolean eof() throws IOException {
        return this._eof;
    }

    public byte[] getData() throws IOException {
        if (this.eof()) {
            throw new IOException("Cannot return empty data");
        }
        return this._data;
    }
}

