/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dbcp.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.seasar.extension.dbcp.ConnectionPool;
import org.seasar.extension.dbcp.ConnectionWrapper;
import org.seasar.extension.dbcp.impl.ConnectionWrapperImpl;
import org.seasar.extension.timer.TimeoutManager;
import org.seasar.extension.timer.TimeoutTarget;
import org.seasar.extension.timer.TimeoutTask;
import org.seasar.framework.exception.SIllegalStateException;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.exception.SSQLException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.SLinkedList;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.TransactionManagerUtil;
import org.seasar.framework.util.TransactionUtil;

public class ConnectionPoolImpl
implements ConnectionPool {
    public static final String readOnly_BINDING = "bindingType=may";
    public static final String transactionIsolationLevel_BINDING = "bindingType=may";
    public static final int DEFAULT_TRANSACTION_ISOLATION_LEVEL = -1;
    private static Logger logger = Logger.getLogger((Class)ConnectionPoolImpl.class);
    private XADataSource xaDataSource;
    private TransactionManager transactionManager;
    private int timeout = 600;
    private int maxPoolSize = 10;
    private int minPoolSize = 0;
    private long maxWait = -1L;
    private boolean allowLocalTx = true;
    private boolean readOnly = false;
    private int transactionIsolationLevel = -1;
    private String validationQuery;
    private long validationInterval;
    private Set activePool = new HashSet();
    private Map txActivePool = new HashMap();
    private SLinkedList freePool = new SLinkedList();
    private TimeoutTask timeoutTask = TimeoutManager.getInstance().addTimeoutTarget(new TimeoutTarget(){

        public void expired() {
        }
    }, Integer.MAX_VALUE, true);

    public XADataSource getXADataSource() {
        return this.xaDataSource;
    }

    public void setXADataSource(XADataSource xaDataSource) {
        this.xaDataSource = xaDataSource;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }

    public boolean isAllowLocalTx() {
        return this.allowLocalTx;
    }

    public void setAllowLocalTx(boolean allowLocalTx) {
        this.allowLocalTx = allowLocalTx;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public int getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    public void setTransactionIsolationLevel(int transactionIsolationLevel) {
        this.transactionIsolationLevel = transactionIsolationLevel;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public long getValidationInterval() {
        return this.validationInterval;
    }

    public void setValidationInterval(long validationInterval) {
        this.validationInterval = validationInterval;
    }

    public int getActivePoolSize() {
        return this.activePool.size();
    }

    public int getTxActivePoolSize() {
        return this.txActivePool.size();
    }

    public int getFreePoolSize() {
        return this.freePool.size();
    }

    public synchronized ConnectionWrapper checkOut() throws SQLException {
        Transaction tx = this.getTransaction();
        if (tx == null && !this.isAllowLocalTx()) {
            throw new SIllegalStateException("ESSR0311", null);
        }
        ConnectionWrapper con = this.getConnectionTxActivePool(tx);
        if (con != null) {
            if (logger.isDebugEnabled()) {
                logger.log("DSSR0007", new Object[]{tx});
            }
            return con;
        }
        long wait = this.maxWait;
        while (this.getMaxPoolSize() > 0 && this.getActivePoolSize() + this.getTxActivePoolSize() >= this.getMaxPoolSize()) {
            if (wait == 0L) {
                throw new SSQLException("ESSR0104", null);
            }
            long startTime = System.currentTimeMillis();
            try {
                this.wait(this.maxWait == -1L ? 0L : wait);
            }
            catch (InterruptedException e) {
                throw new SSQLException("ESSR0104", null, (Throwable)e);
            }
            long elapseTime = System.currentTimeMillis() - startTime;
            if (wait <= 0L) continue;
            wait -= Math.min(wait, elapseTime);
        }
        con = this.checkOutFreePool(tx);
        if (con == null) {
            con = this.createConnection(tx);
        }
        if (tx == null) {
            this.setConnectionActivePool(con);
        } else {
            TransactionUtil.enlistResource((Transaction)tx, (XAResource)con.getXAResource());
            TransactionUtil.registerSynchronization((Transaction)tx, (Synchronization)new SynchronizationImpl(tx));
            this.setConnectionTxActivePool(tx, con);
        }
        con.setReadOnly(this.readOnly);
        if (this.transactionIsolationLevel != -1) {
            con.setTransactionIsolation(this.transactionIsolationLevel);
        }
        if (logger.isDebugEnabled()) {
            logger.log("DSSR0007", new Object[]{tx});
        }
        return con;
    }

    private Transaction getTransaction() {
        return TransactionManagerUtil.getTransaction((TransactionManager)this.transactionManager);
    }

    private ConnectionWrapper getConnectionTxActivePool(Transaction tx) {
        return (ConnectionWrapper)this.txActivePool.get(tx);
    }

    private ConnectionWrapper checkOutFreePool(Transaction tx) {
        if (this.freePool.isEmpty()) {
            return null;
        }
        FreeItem item = (FreeItem)this.freePool.removeLast();
        ConnectionWrapper con = item.getConnection();
        con.init(tx);
        item.destroy();
        if (StringUtil.isEmpty((String)this.validationQuery)) {
            return con;
        }
        if (this.validateConnection(con, item.getPooledTime())) {
            return con;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateConnection(ConnectionWrapper con, long pooledTime) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - pooledTime < this.validationInterval) {
            return true;
        }
        try {
            PreparedStatement ps = con.prepareStatement(this.validationQuery);
            try {
                ps.executeQuery();
            }
            finally {
                ps.close();
            }
        }
        catch (Exception e) {
            try {
                con.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            for (SLinkedList.Entry entry = this.freePool.getFirstEntry(); entry != null; entry = entry.getNext()) {
                FreeItem item = (FreeItem)entry.getElement();
                try {
                    item.getConnection().closeReally();
                    continue;
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            this.freePool.clear();
            logger.log("ESSR0096", null, (Throwable)e);
            return false;
        }
        return true;
    }

    private ConnectionWrapper createConnection(Transaction tx) throws SQLException {
        XAConnection xaConnection = this.xaDataSource.getXAConnection();
        Connection connection = xaConnection.getConnection();
        ConnectionWrapperImpl con = new ConnectionWrapperImpl(xaConnection, connection, this, tx);
        if (logger.isDebugEnabled()) {
            logger.log("DSSR0006", null);
        }
        return con;
    }

    private void setConnectionTxActivePool(Transaction tx, ConnectionWrapper connection) {
        this.txActivePool.put(tx, connection);
    }

    private void setConnectionActivePool(ConnectionWrapper connection) {
        this.activePool.add(connection);
    }

    public synchronized void release(ConnectionWrapper connection) {
        this.activePool.remove(connection);
        Transaction tx = this.getTransaction();
        if (tx != null) {
            this.txActivePool.remove(tx);
        }
        connection.closeReally();
        this.notify();
    }

    public synchronized void checkIn(ConnectionWrapper connection) {
        this.activePool.remove(connection);
        this.checkInFreePool(connection);
    }

    private void checkInFreePool(ConnectionWrapper con) {
        if (this.getMaxPoolSize() > 0) {
            try {
                Connection pc = con.getPhysicalConnection();
                pc.setAutoCommit(true);
                ConnectionWrapperImpl newCon = new ConnectionWrapperImpl(con.getXAConnection(), pc, this, null);
                con.cleanup();
                this.freePool.addLast((Object)new FreeItem(newCon));
                this.notify();
            }
            catch (SQLException e) {
                throw new SQLRuntimeException(e);
            }
        } else {
            con.closeReally();
        }
    }

    public synchronized void checkInTx(Transaction tx) {
        if (tx == null) {
            return;
        }
        if (this.getTransaction() != null) {
            return;
        }
        ConnectionWrapper con = (ConnectionWrapper)this.txActivePool.remove(tx);
        if (con == null) {
            return;
        }
        this.checkInFreePool(con);
    }

    public final synchronized void close() {
        ConnectionWrapper con;
        for (SLinkedList.Entry e = this.freePool.getFirstEntry(); e != null; e = e.getNext()) {
            FreeItem item = (FreeItem)e.getElement();
            item.getConnection().closeReally();
            item.destroy();
        }
        this.freePool.clear();
        Iterator<Object> i = this.txActivePool.values().iterator();
        while (i.hasNext()) {
            con = (ConnectionWrapper)i.next();
            con.closeReally();
        }
        this.txActivePool.clear();
        i = this.activePool.iterator();
        while (i.hasNext()) {
            con = (ConnectionWrapper)i.next();
            con.closeReally();
        }
        this.activePool.clear();
        this.timeoutTask.cancel();
    }

    public class SynchronizationImpl
    implements Synchronization {
        protected final Transaction tx;

        public SynchronizationImpl(Transaction tx) {
            this.tx = tx;
        }

        public final void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            switch (status) {
                case 3: 
                case 4: {
                    ConnectionPoolImpl.this.checkInTx(this.tx);
                }
            }
        }
    }

    private class FreeItem
    implements TimeoutTarget {
        private ConnectionWrapper connectionWrapper_;
        private TimeoutTask timeoutTask_;
        private long pooledTime;

        FreeItem(ConnectionWrapper connectionWrapper) {
            this.connectionWrapper_ = connectionWrapper;
            this.timeoutTask_ = TimeoutManager.getInstance().addTimeoutTarget(this, ConnectionPoolImpl.this.timeout, false);
            this.pooledTime = System.currentTimeMillis();
        }

        public ConnectionWrapper getConnection() {
            return this.connectionWrapper_;
        }

        public long getPooledTime() {
            return this.pooledTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void expired() {
            Object object = ConnectionPoolImpl.this;
            synchronized (object) {
                if (ConnectionPoolImpl.this.freePool.size() > ConnectionPoolImpl.this.minPoolSize) {
                    ConnectionPoolImpl.this.freePool.remove((Object)this);
                }
            }
            object = this;
            synchronized (object) {
                if (this.timeoutTask_ != null) {
                    this.timeoutTask_.cancel();
                    this.timeoutTask_ = null;
                }
                if (this.connectionWrapper_ != null) {
                    this.connectionWrapper_.closeReally();
                    this.connectionWrapper_ = null;
                }
            }
        }

        public synchronized void destroy() {
            if (this.timeoutTask_ != null) {
                this.timeoutTask_.cancel();
                this.timeoutTask_ = null;
            }
            this.connectionWrapper_ = null;
        }
    }
}

