/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import org.seasar.framework.exception.ParseRuntimeException;
import org.seasar.framework.util.StringUtil;

public class TimeConversionUtil {
    protected TimeConversionUtil() {
    }

    public static Time toTime(Object o) {
        return TimeConversionUtil.toTime(o, null);
    }

    public static Time toTime(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return TimeConversionUtil.toTime((String)o, pattern);
        }
        if (o instanceof Time) {
            return (Time)o;
        }
        if (o instanceof Calendar) {
            return new Time(((Calendar)o).getTime().getTime());
        }
        return TimeConversionUtil.toTime(o.toString(), pattern);
    }

    public static Time toTime(String s, String pattern) {
        return TimeConversionUtil.toTime(s, pattern, Locale.getDefault());
    }

    public static Time toTime(String s, String pattern, Locale locale) {
        if (StringUtil.isEmpty(s)) {
            return null;
        }
        SimpleDateFormat sdf = TimeConversionUtil.getDateFormat(s, pattern, locale);
        try {
            return new Time(sdf.parse(s).getTime());
        }
        catch (ParseException ex) {
            throw new ParseRuntimeException(ex);
        }
    }

    public static SimpleDateFormat getDateFormat(String s, String pattern, Locale locale) {
        if (pattern != null) {
            return new SimpleDateFormat(pattern);
        }
        return TimeConversionUtil.getDateFormat(s, locale);
    }

    public static SimpleDateFormat getDateFormat(String s, Locale locale) {
        String pattern = TimeConversionUtil.getPattern(locale);
        if (s.length() == pattern.length()) {
            return new SimpleDateFormat(pattern);
        }
        String shortPattern = TimeConversionUtil.convertShortPattern(pattern);
        if (s.length() == shortPattern.length()) {
            return new SimpleDateFormat(shortPattern);
        }
        return new SimpleDateFormat(pattern);
    }

    public static String getPattern(Locale locale) {
        return "HH:mm:ss";
    }

    public static String convertShortPattern(String pattern) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c != 'h' && c != 'H' && c != 'm' && c != 's') continue;
            buf.append(c);
        }
        return buf.toString();
    }
}

